<?php
require_once 'config.php';
header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

if ($action == 'get_campaigns') {
    $sql = "SELECT * FROM campaigns ORDER BY id DESC";
    $result = $conn->query($sql);
    $data = [];
    while($row = $result->fetch_assoc()) { $data[] = $row; }
    echo json_encode($data);
}

if ($action == 'submit_donation' && $method == 'POST') {
    $id_user = $_POST['id_user'];
    $nama_user = $_POST['nama_user'];
    $amount = intval($_POST['amount']);
    $campaign_id = intval($_POST['campaign_id']);

    // 1. Potong Saldo via Closed API BukaOlshop
    $ch = curl_init("https://bukaolshop.net/api/v1/member/saldo");
    $payload = json_encode([
        "id_user" => $id_user,
        "tipe" => "kurang",
        "jumlah" => $amount,
        "catatan_saldo" => "Donasi Program ID: " . $campaign_id,
        "notifikasi" => true
    ]);
    
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type:application/json', "Authorization: Bearer $api_key"]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res_api = json_decode(curl_exec($ch), true);
    curl_close($ch);

    if (isset($res_api['code']) && $res_api['code'] == 200) {
        // 2. Simpan ke Database Lokal
        $stmt = $conn->prepare("INSERT INTO donations (campaign_id, user_id, user_name, amount) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("issi", $campaign_id, $id_user, $nama_user, $amount);
        $stmt->execute();

        // 3. Update Total Terkumpul di Campaign
        $conn->query("UPDATE campaigns SET current_amount = current_amount + $amount WHERE id = $campaign_id");
        
        echo json_encode(["status" => "success", "message" => "Terima kasih! Donasi berhasil."]);
    } else {
        echo json_encode(["status" => "error", "message" => $res_api['status'] ?? "Saldo tidak cukup atau API error"]);
    }
}